/*----------------------------------------------------------------------------
 * Name:    HCI.h
 * Purpose: HCI definitions
 * Note(s):
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2012 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/

#ifndef _HCI_H_
#define _HCI_H_

#include "ht32f5xxxx_01.h"

/* HCI packet type */

#define	HCI_CMD_PKG				0x01
#define	HCI_ACL_PKG 			0x02
#define	HCI_SCL_PKG				0x03
#define	HCI_EVENT_PKG			0x04

#define  EVENT_CMD_COMPLETE   0x0E

#define  HCI_RESET_OPCODE     0x0C03
#define  HCI_RX_TEST_OPCODE   0x201D
#define  HCI_TX_TEST_OPCODE   0x201E
#define  HCI_END_TEST_OPCODE  0x201F

/* DTM data format */
enum
{
	DTM_FORMAT_PRBS9 = 0,
	DTM_FORMAT_11110000,
	DTM_FORMAT_10101010,
	DTM_FORMAT_PRBS15,
	DTM_FORMAT_11111111,
	DTM_FORMAT_00000000,
	DTM_FORMAT_00001111,
	DTM_FORMAT_01010101
};

typedef struct __attribute__((packed))
{
   u8		type;
   u16 	opcode;
   u8 	length;
   u8 	param[];
}tHCI_CMD_PKG;

typedef struct __attribute__((packed))
{
   u8 	type;
   u8 	event;
   u8 	length;
   u8 	param_num;
   u8 	param[];
}tHCI_EVENT_PKG;


#endif
